/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;

public class ItemToast
implements Toast {
    private static final ResourceLocation TEXTURE = ResourceLocation.withDefaultNamespace((String)"toast/recipe");
    public static final Object TRANSFER_NO_RESPONSE_TOKEN = new Object();
    private static final long DISPLAY_TIME = 7000L;
    private static final int MAX_LINE_SIZE = 200;
    private static final int IMAGE_SIZE = 16;
    private static final int LINE_SPACING = 10;
    private static final int MARGIN = 8;
    private final ItemStack stack;
    private final Component title;
    private final List<FormattedCharSequence> message;
    private final Object token;
    private final int width;
    private boolean isNew = true;
    private long firstDisplay;

    public ItemToast(Minecraft minecraft, ItemStack stack, Component title, Component message, Object token) {
        this.stack = stack;
        this.title = title;
        this.token = token;
        Font font = minecraft.font;
        this.message = font.split((FormattedText)message, 200);
        this.width = Math.max(200, this.message.stream().mapToInt(arg_0 -> ((Font)font).width(arg_0)).max().orElse(200)) + 24 + 16;
    }

    public void showOrReplace(ToastComponent toasts) {
        ItemToast existing = (ItemToast)toasts.getToast(ItemToast.class, this.getToken());
        if (existing != null) {
            existing.isNew = true;
        } else {
            toasts.addToast((Toast)this);
        }
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return 26 + this.message.size() * 10;
    }

    public Object getToken() {
        return this.token;
    }

    public Toast.Visibility render(GuiGraphics graphics, ToastComponent component, long time) {
        if (this.isNew) {
            this.firstDisplay = time;
            this.isNew = false;
        }
        if (this.width == 160 && this.message.size() <= 1) {
            graphics.blitSprite(TEXTURE, 0, 0, this.width, this.height());
        } else {
            int height = this.height();
            int bottom = Math.min(4, height - 28);
            ItemToast.renderBackgroundRow(graphics, this.width, 0, 0, 28);
            for (int i = 28; i < height - bottom; i += 10) {
                ItemToast.renderBackgroundRow(graphics, this.width, 16, i, Math.min(16, height - i - bottom));
            }
            ItemToast.renderBackgroundRow(graphics, this.width, 32 - bottom, height - bottom, bottom);
        }
        int textX = 8;
        if (!this.stack.isEmpty()) {
            textX += 24;
            graphics.renderFakeItem(this.stack, 8, 8 + this.height() / 2 - 16);
        }
        graphics.drawString(component.getMinecraft().font, this.title, textX, 8, -11534256, false);
        for (int i = 0; i < this.message.size(); ++i) {
            graphics.drawString(component.getMinecraft().font, this.message.get(i), textX, 10 + (i + 1) * 10, -16777216, false);
        }
        return time - this.firstDisplay < 7000L ? Toast.Visibility.SHOW : Toast.Visibility.HIDE;
    }

    private static void renderBackgroundRow(GuiGraphics graphics, int x, int u, int y, int height) {
        int leftOffset = u == 0 ? 20 : 5;
        int rightOffset = Math.min(60, x - leftOffset);
        graphics.blitSprite(TEXTURE, 160, 32, 0, u, 0, y, leftOffset, height);
        for (int k = leftOffset; k < x - rightOffset; k += 64) {
            graphics.blitSprite(TEXTURE, 160, 32, 32, u, k, y, Math.min(64, x - k - rightOffset), height);
        }
        graphics.blitSprite(TEXTURE, 160, 32, 160 - rightOffset, u, x - rightOffset, y, rightOffset, height);
    }
}

